/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testplots;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEParts;
import appeng.me.service.EnergyService;
import appeng.server.testplots.TestPlot;
import appeng.server.testworld.PlotBuilder;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public final class SubnetPlots {
    private static final AEItemKey STICK = AEItemKey.of((class_1935)class_1802.field_8600);

    private SubnetPlots() {
    }

    @TestPlot(value="subnet")
    public static void subnet(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        plot.creativeEnergyCell(origin.method_10074());
        plot.cable(origin).part(class_2350.field_11043, AEParts.TERMINAL).part(class_2350.field_11035, AEParts.STORAGE_BUS).part(class_2350.field_11034, AEParts.QUARTZ_FIBER);
        plot.cable(origin.method_10078());
        plot.cable(origin.method_10078().method_10072());
        plot.cable(origin.method_10072()).part(class_2350.field_11043, AEParts.INTERFACE);
        plot.storageDrive(origin.method_10072().method_10084());
        class_2338 subNetPos = origin.method_10072();
        class_2338 mainNetPos = origin;
        plot.test(helper -> helper.method_36041().method_36079(() -> helper.getGrid(subNetPos)).method_36079(() -> helper.getGrid(mainNetPos)).method_36085(() -> {
            IGrid mainGrid = helper.getGrid(mainNetPos);
            IStorageService storageService = mainGrid.getService(IStorageService.class);
            long inserted = storageService.getInventory().insert(STICK, 1L, Actionable.MODULATE, null);
            helper.check(inserted == 1L, "inserted != 1: " + inserted, mainNetPos);
            KeyCounter inventory = storageService.getInventory().getAvailableStacks();
            helper.check(inventory.get(STICK) == 1L, "stick not present", mainNetPos);
        }).method_36076(10).method_36085(() -> {
            IGrid mainGrid = helper.getGrid(mainNetPos);
            IStorageService storageService = mainGrid.getService(IStorageService.class);
            KeyCounter inventory = storageService.getInventory().getAvailableStacks();
            helper.check(inventory.get(STICK) == 1L, "stick not present in tick #10", mainNetPos);
            long extracted = storageService.getInventory().extract(STICK, 1L, Actionable.MODULATE, null);
            helper.check(extracted == 1L, "unable to extract", mainNetPos);
        }).method_36075());
    }

    @TestPlot(value="energy_overlay")
    public static void energy_overlay(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        plot.cable(origin).part(class_2350.field_11034, AEParts.QUARTZ_FIBER);
        plot.block(origin.method_10078(), AEBlocks.DENSE_ENERGY_CELL);
        plot.block(origin.method_10067(), AEBlocks.ENERGY_CELL);
        plot.cable(origin.method_10067().method_10067()).part(class_2350.field_11034, AEParts.QUARTZ_FIBER);
        plot.test(helper -> helper.method_36041().method_36079(() -> helper.getGrid(origin)).method_36085(() -> {
            IGrid denseCellGrid = helper.getGrid(origin.method_10078());
            IGrid cellGrid = helper.getGrid(origin.method_10067());
            IGrid noCellGrid = helper.getGrid(origin.method_10067().method_10067());
            EnergyService denseCellService = (EnergyService)denseCellGrid.getService(IEnergyService.class);
            EnergyService cellService = (EnergyService)cellGrid.getService(IEnergyService.class);
            EnergyService noCellService = (EnergyService)noCellGrid.getService(IEnergyService.class);
            denseCellService.injectPower(1.0, Actionable.MODULATE);
            helper.check(SubnetPlots.getLocalStoredPower(denseCellService) == 1.0, "expect power = 1", origin.method_10078());
            cellService.injectPower(1.0, Actionable.MODULATE);
            helper.check(SubnetPlots.getLocalStoredPower(denseCellService) == 2.0, "expect power = 2", origin.method_10078());
            noCellService.injectPower(1.0, Actionable.MODULATE);
            helper.check(SubnetPlots.getLocalStoredPower(denseCellService) == 3.0, "expect power = 3", origin.method_10078());
            denseCellService.extractAEPower(1.0, Actionable.MODULATE, PowerMultiplier.ONE);
            helper.check(SubnetPlots.getLocalStoredPower(denseCellService) == 2.0, "expect power = 2", origin.method_10078());
            cellService.extractAEPower(1.0, Actionable.MODULATE, PowerMultiplier.ONE);
            helper.check(SubnetPlots.getLocalStoredPower(denseCellService) == 1.0, "expect power = 1", origin.method_10078());
            noCellService.extractAEPower(1.0, Actionable.MODULATE, PowerMultiplier.ONE);
            helper.check(SubnetPlots.getLocalStoredPower(denseCellService) == 0.0, "expect power = 0", origin.method_10078());
        }).method_36075());
    }

    @TestPlot(value="multi_storage_bus")
    public static void multi_storage_bus(PlotBuilder plot) {
        class_2338 origin = class_2338.field_10980;
        plot.storageDrive(origin.method_10067());
        plot.block(origin, AEBlocks.INTERFACE);
        plot.block(origin.method_10078(), AEBlocks.INTERFACE);
        plot.creativeEnergyCell(origin.method_10078().method_10078());
        class_2338 subnetOrigin = origin.method_10095();
        plot.cable(subnetOrigin).part(class_2350.field_11035, AEParts.STORAGE_BUS, bus -> bus.getConfig().addFilter((class_1935)class_1802.field_8197));
        plot.cable(subnetOrigin.method_10078()).part(class_2350.field_11035, AEParts.STORAGE_BUS, bus -> bus.getConfig().addFilter((class_1935)class_1802.field_8737));
        plot.cable(subnetOrigin.method_10078().method_10078()).part(class_2350.field_11035, AEParts.QUARTZ_FIBER).part(class_2350.field_11043, AEParts.TERMINAL);
        plot.test(helper -> helper.method_36041().method_36079(() -> {
            helper.getGrid(origin);
            helper.getGrid(subnetOrigin);
        }).method_36085(() -> {
            IGrid mainGrid = helper.getGrid(origin);
            MEStorage mainInv = mainGrid.getStorageService().getInventory();
            mainInv.insert(AEItemKey.of((class_1935)class_1802.field_8197), 64L, Actionable.MODULATE, IActionSource.empty());
            mainInv.insert(AEItemKey.of((class_1935)class_1802.field_8737), 64L, Actionable.MODULATE, IActionSource.empty());
        }).method_36076(1).method_36085(() -> {
            IGrid subnet = helper.getGrid(subnetOrigin);
            helper.assertContains(subnet, class_1802.field_8197);
            helper.assertContains(subnet, class_1802.field_8737);
        }).method_36075());
    }

    private static double getLocalStoredPower(EnergyService service) {
        service.refreshPower();
        return service.getStoredPower();
    }
}

